// SetupDialog.cpp : implementation file
//

#include "stdafx.h"
#include "ScheduleRecording.h"
#include "SetupDialog.h"
#include "afxdialogex.h"

HMODULE GetMyModuleHandle()
{
	static int s_module_marker = 0;

	MEMORY_BASIC_INFORMATION memory_basic_information;

	if( !VirtualQuery( &s_module_marker, &memory_basic_information, sizeof( memory_basic_information ) ) )
	{
		return NULL;
	}

	return (HMODULE)memory_basic_information.AllocationBase;
}

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[DEVICE.RECORDING] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 19, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

// CSetupDialog dialog

IMPLEMENT_DYNAMIC(CSetupDialog, CDialogEx)

CSetupDialog::CSetupDialog(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSetupDialog::IDD, pParent)
{
	m_bHasSubStream				= FALSE;

	m_bHasBFrame					= FALSE;

	m_nCHNum						= 0;

	m_dwTxtDataSize				= 0;

	m_hGlobalRes						= NULL;

	for ( ULONG i = 0 ; i < MAX_CHANNEL ; i++ )
	{
		m_pMainFileRenderer[ i ]		=		NULL;

		m_bManualRecord[ i ]				=		FALSE;

		//m_bRecordManually[ i ]			=		FALSE;

		//m_bStopManually[ i ]				=		FALSE;		
	}	
}

CSetupDialog::~CSetupDialog()
{
}

void CSetupDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDialog)
	DDX_Control(pDX, IDC_COMBO_STANDARD, m_comboStandard);
	DDX_Control(pDX, IDC_EDIT_STOP_RECORD, m_editStopRecord);
	DDX_Control(pDX, IDC_EDIT_START_RECORD, m_editStartRecord);
	DDX_Control(pDX, IDC_EDIT_SCHEDULE_RECORD, m_editScheduleRecord);	
	DDX_Control(pDX, IDC_EDIT_FILE_TYPE, m_editFileType);
	DDX_Control(pDX, IDC_EDIT_AUDIO_ENCODER, m_editAudioEncoder);
	DDX_Control(pDX, IDC_EDIT_VIDEO_ENCODER, m_editVideoEncoder);
	DDX_Control(pDX, IDC_EDIT_BFRAME, m_editBFrame);
	DDX_Control(pDX, IDC_EDIT_GOP, m_editGOP);
	DDX_Control(pDX, IDC_EDIT_QUALITY, m_editQuality);
	DDX_Control(pDX, IDC_EDIT_BITRATE, m_editBitRate);
	DDX_Control(pDX, IDC_EDIT_RECORDMODE, m_editRecordMode);
	DDX_Control(pDX, IDC_EDIT_FRAMERATE, m_editFrameRate);
	DDX_Control(pDX, IDC_EDIT_DEINTERLACE, m_editDeinterlace);
	DDX_Control(pDX, IDC_EDIT_RESOLUTION, m_editResolution);
	DDX_Control(pDX, IDC_EDIT_CHANNEL, m_editChannel);
	DDX_Control(pDX, IDC_EDIT_STANDARD, m_editStandard);	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupDialog, CDialogEx)
	//{{AFX_MSG_MAP(CSetupDialog)
	ON_WM_DESTROY()
	ON_WM_SYSCOMMAND()
	ON_WM_TIMER()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(IDM_SCHEDULE_RECORD, OnScheduleRecord)
	ON_CBN_SELCHANGE(IDC_COMBO_STANDARD, OnSelChangeComboStandard)
	ON_CONTROL_RANGE(CBN_SELCHANGE, IDC_COMBO_RECORDMODE_CH01, IDC_COMBO_RECORDMODE_CH01 + 16 , OnMainRecordModeSelectChange)
	ON_CONTROL_RANGE(CBN_SELCHANGE, IDC_COMBO_RECORDMODE_CH01_SUB, IDC_COMBO_RECORDMODE_CH01_SUB + 16 , OnSubRecordModeSelectChange)

	ON_COMMAND_RANGE(IDC_BTN_START_RECORD_CH01, IDC_BTN_START_RECORD_CH01 + 16, OnMainStartRecord)
	ON_COMMAND_RANGE(IDC_BTN_STOP_RECORD_CH01, IDC_BTN_STOP_RECORD_CH01 + 16, OnMainStopRecord)	
	ON_COMMAND_RANGE(IDC_BTN_SCHEDULE_RECORD_CH01, IDC_BTN_SCHEDULE_RECORD_CH01 + 16, OnMainScheduleRecord)	
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// CSetupDialog message handlers

BOOL CSetupDialog::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	SetWindowText( m_strCaption );

	m_editStandard.SetWindowText( "STANDARD" );

	m_editChannel.SetWindowText( "CHANNEL" );

	m_editResolution.SetWindowText( "RESOLUTION" );

	m_editDeinterlace.SetWindowText( "DEINTERLACE" );

	m_editFrameRate.SetWindowText( "FRAMERATE" );

	m_editRecordMode.SetWindowText( "RECORD MODE" );

	m_editBitRate.SetWindowText( "BITRATE" );

	m_editQuality.SetWindowText( "QUALITY" );

	m_editGOP.SetWindowText( "GOP" );

	m_editBFrame.SetWindowText( "BFRAME" );

	m_editVideoEncoder.SetWindowText( "VIDEO ENCODER" );

	m_editAudioEncoder.SetWindowText( "AUDIO ENCODER" );

	m_editFileType.SetWindowText( "FILE TYPE" );

	m_editStartRecord.SetWindowText( "RECORD" );

	m_editStopRecord.SetWindowText( "RECORD" );

	m_editScheduleRecord.SetWindowText( "RECORD" );

	//m_PopupMenu.CreatePopupMenu();

	//m_PopupMenu.AppendMenu(MF_STRING, IDM_SCHEDULE_RECORD, "SCHEDULE RECORD" );

	//m_PopupMenu.EnableMenuItem(IDM_SCHEDULE_RECORD, MF_BYCOMMAND | MF_ENABLED );	

	m_comboStandard.SetCurSel( CUR_STANDARD );

	InitResource();

	ULONG i = 0;

	for ( i = 0 ; i < MAX_CHANNEL ; i++ )
	{
		InitializeCriticalSection( &m_oSchduleRecordDlg.m_hScheduleArrayAccessCriticalSection[ i ] );
	}

	m_strScheduleDir = GetWorkingPath( "" );

	m_strScheduleDir += "SCHEDULE.RECORDING";

	if ( !IsDirectoryExist( m_strScheduleDir ) )
	{
		CreateDirectory( m_strScheduleDir, NULL );
	}	

	HWND hBtnChannel= ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_CHANNEL );

	RECT rectBtnChannel;

	::GetWindowRect( hBtnChannel, &rectBtnChannel );

	ULONG nItemWidth = rectBtnChannel.right - rectBtnChannel.left;

	ULONG nItemHeight = rectBtnChannel.bottom - rectBtnChannel.top;	

	ScreenToClient( &rectBtnChannel );

	CString str;

	LONG nLastLeft = 0, nLastBottom= 0, nLastResolutionBottom = 0, nLastDeinterlaceBottom = 0, nLastFrameRateBottom = 0, nLastRecordModeBottom = 0, nLastBitrateBottom = 0; 

	LONG nLastQualityBottom = 0, nLastGopBottom = 0, nLastBFrameBottom = 0, nLastVideoEncoderBottom = 0, nLastAudioEncoderBottom = 0, nLastFileTypeBottom = 0, nLastStartRecordBottom = 0, nLastStopRecordBottom = 0;

	// CREATE MAIN CHANNEL EDIT
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{	
		str.Format( "CH%02d" , i + 1 );		

		m_editMainChannel[ i ].CreateEx( WS_EX_CLIENTEDGE, _T("EDIT"), str, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_EDIT_CHANNEL_CH01 +  i );		

		m_editMainChannel[ i ].MoveWindow( rectBtnChannel.left, rectBtnChannel.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );

		nLastBottom = rectBtnChannel.bottom + ( i * nItemHeight );

		m_editMainChannel[ i ].SetReadOnly();		

		m_editMainChannel[ i ].ShowWindow( SW_SHOW );
	}	

	nLastLeft = rectBtnChannel.left;
	
	rectBtnChannel.bottom = nLastBottom + nItemHeight;

	// CREATE SUB CHANNEL EDIT
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			str.Format( "CH%02d.SUB" , i + 1 );		

			m_editSubChannel[ i ].CreateEx( WS_EX_CLIENTEDGE, _T("EDIT"), str, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_EDIT_CHANNEL_CH01_SUB +  i );		

			m_editSubChannel[ i ].MoveWindow( nLastLeft, rectBtnChannel.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );

			nLastBottom = rectBtnChannel.bottom + ( i * nItemHeight );

			m_editSubChannel[ i ].SetReadOnly();		

			m_editSubChannel[ i ].ShowWindow( SW_SHOW );
		}

		rectBtnChannel.bottom = nLastBottom + nItemHeight;
	}	

	HWND hBtnResolution= ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_RESOLUTION );

	RECT rectBtnResolution;

	::GetWindowRect( hBtnResolution, &rectBtnResolution );

	ScreenToClient( &rectBtnResolution );

	// CREATE MAIN RESOLUTION COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainResolution[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_RESOLUTION_CH01 +  i );		

		m_comboxMainResolution[ i ].MoveWindow( rectBtnResolution.left, rectBtnResolution.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastResolutionBottom = rectBtnResolution.bottom + ( i * nItemHeight );

		for ( ULONG j = 0 ; j < m_strVecNtscRes.size() ; j++ )
		{
			m_comboxMainResolution[ i ].AddString( m_strVecNtscRes[ j ].c_str() );
		}

		CRect rc; m_comboxMainResolution[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainResolution[ i ].MoveWindow(&rc); 

		m_comboxMainResolution[ i ].ShowWindow( SW_SHOW );

		m_comboxMainResolution[ i ].SetCurSel( 0 );
	}

	rectBtnResolution.bottom = nLastResolutionBottom + nItemHeight;

	// CREATE SUB RESOLUTION COMBOBOX
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubResolution[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_RESOLUTION_CH01_SUB +  i );		

			m_comboxSubResolution[ i ].MoveWindow( rectBtnResolution.left, rectBtnResolution.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastResolutionBottom = rectBtnResolution.bottom + ( i * nItemHeight );

			for ( ULONG j = 0 ; j < m_strVecNtscResSub.size() ; j++ )
			{
				m_comboxSubResolution[ i ].AddString( m_strVecNtscResSub[ j ].c_str() );
			}

			CRect rc; m_comboxSubResolution[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubResolution[ i ].MoveWindow(&rc); 

			m_comboxSubResolution[ i ].ShowWindow( SW_SHOW );

			m_comboxSubResolution[ i ].SetCurSel( 0 );
		}
	}

	HWND hBtnDeinterlace = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_DEINTERLACE );

	RECT rectBtnDeinterlace;

	::GetWindowRect( hBtnDeinterlace, &rectBtnDeinterlace );

	ScreenToClient( &rectBtnDeinterlace );

	// CREATE MAIN DEINTERLACE COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainDeinterlace[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_DEINTERLACE_CH01 +  i );

		m_comboxMainDeinterlace[ i ].MoveWindow( rectBtnDeinterlace.left, rectBtnDeinterlace.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastDeinterlaceBottom = rectBtnDeinterlace.bottom + ( i * nItemHeight );

		m_comboxMainDeinterlace[ i ].AddString( "DISABLE" );

		m_comboxMainDeinterlace[ i ].AddString( "METHOD#01" );

		m_comboxMainDeinterlace[ i ].AddString( "METHOD#02" );

		m_comboxMainDeinterlace[ i ].AddString( "METHOD#07" );

		CRect rc; m_comboxMainDeinterlace[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainDeinterlace[ i ].MoveWindow(&rc); 

		m_comboxMainDeinterlace[ i ].ShowWindow( SW_SHOW );

		m_comboxMainDeinterlace[ i ].SetCurSel( 0 );
	}

	rectBtnDeinterlace.bottom = nLastDeinterlaceBottom + nItemHeight;

	// CREATE SUB DEINTERLACE COMBOBOX
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubDeinterlace[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_DEINTERLACE_CH01_SUB +  i );		

			m_comboxSubDeinterlace[ i ].MoveWindow( rectBtnDeinterlace.left, rectBtnDeinterlace.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastDeinterlaceBottom = rectBtnDeinterlace.bottom + ( i * nItemHeight );

			m_comboxSubDeinterlace[ i ].AddString( "DISABLE" );

			m_comboxSubDeinterlace[ i ].AddString( "METHOD#01" );

			m_comboxSubDeinterlace[ i ].AddString( "METHOD#02" );

			m_comboxSubDeinterlace[ i ].AddString( "METHOD#07" );

			CRect rc; m_comboxSubDeinterlace[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubDeinterlace[ i ].MoveWindow(&rc); 

			m_comboxSubDeinterlace[ i ].ShowWindow( SW_SHOW );

			m_comboxSubDeinterlace[ i ].SetCurSel( 0 );
		}
	}

	HWND hBtnFrameRate = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_FRAMERATE );

	RECT rectBtnFrameRate;

	::GetWindowRect( hBtnFrameRate, &rectBtnFrameRate );

	ScreenToClient( &rectBtnFrameRate );

	// CREATE MAIN FRAMERATE COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainFrameRate[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_FRAMERATE_CH01 +  i );

		m_comboxMainFrameRate[ i ].MoveWindow( rectBtnFrameRate.left, rectBtnFrameRate.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastFrameRateBottom = rectBtnFrameRate.bottom + ( i * nItemHeight );

		for ( ULONG j = 0 ; j < m_strVecNtscFrameRate.size() ; j++ )
		{
			m_comboxMainFrameRate[ i ].AddString( m_strVecNtscFrameRate[ j ].c_str() );
		}

		CRect rc; m_comboxMainFrameRate[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainFrameRate[ i ].MoveWindow(&rc); 

		m_comboxMainFrameRate[ i ].ShowWindow( SW_SHOW );

		m_comboxMainFrameRate[ i ].SetCurSel( 0 );
	}

	 rectBtnFrameRate.bottom = nLastFrameRateBottom + nItemHeight;

	// CREATE SUB FRAMERATE COMBOBOX
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubFrameRate[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_FRAMERATE_CH01_SUB +  i );		

			m_comboxSubFrameRate[ i ].MoveWindow( rectBtnFrameRate.left, rectBtnFrameRate.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastFrameRateBottom = rectBtnFrameRate.bottom + ( i * nItemHeight );

			for ( ULONG j = 0 ; j < m_strVecNtscFrameRate.size() ; j++ )
			{
				m_comboxSubFrameRate[ i ].AddString( m_strVecNtscFrameRate[ j ].c_str() );
			}

			CRect rc; m_comboxSubFrameRate[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubFrameRate[ i ].MoveWindow(&rc); 

			m_comboxSubFrameRate[ i ].ShowWindow( SW_SHOW );

			m_comboxSubFrameRate[ i ].SetCurSel( 0 );
		}
	}

	HWND hBtnRecordMode = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_RECORDMODE );

	RECT rectBtnRecordMode;

	::GetWindowRect( hBtnRecordMode, &rectBtnRecordMode );

	ScreenToClient( &rectBtnRecordMode );

	// CREATE MAIN RECORD MODE COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainRecordMode[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_RECORDMODE_CH01 +  i );

		m_comboxMainRecordMode[ i ].MoveWindow( rectBtnRecordMode.left, rectBtnRecordMode.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastRecordModeBottom = rectBtnRecordMode.bottom + ( i * nItemHeight );

		for ( ULONG j = 0 ; j < m_strVecNtscRecordMode.size() ; j++ )
		{
			m_comboxMainRecordMode[ i ].AddString( m_strVecNtscRecordMode[ j ].c_str() );
		}

		CRect rc; m_comboxMainRecordMode[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainRecordMode[ i ].MoveWindow(&rc); 

		m_comboxMainRecordMode[ i ].ShowWindow( SW_SHOW );

		m_comboxMainRecordMode[ i ].SetCurSel( 0 );
	}

	 rectBtnRecordMode.bottom = nLastRecordModeBottom + nItemHeight;

	// CREATE SUB RECORD MODE COMBOBOX
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubRecordMode[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_RECORDMODE_CH01_SUB +  i );

			m_comboxSubRecordMode[ i ].MoveWindow( rectBtnRecordMode.left, rectBtnRecordMode.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastRecordModeBottom = rectBtnRecordMode.bottom + ( i * nItemHeight );

			for ( ULONG j = 0 ; j < m_strVecNtscRecordMode.size() ; j++ )
			{
				m_comboxSubRecordMode[ i ].AddString( m_strVecNtscRecordMode[ j ].c_str() );
			}

			CRect rc; m_comboxSubRecordMode[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubRecordMode[ i ].MoveWindow(&rc); 

			m_comboxSubRecordMode[ i ].ShowWindow( SW_SHOW );

			m_comboxSubRecordMode[ i ].SetCurSel( 0 );
		}
	}
	HWND hBtnBitrate = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_BITRATE );

	RECT rectBtnBitrate;

	::GetWindowRect( hBtnBitrate, &rectBtnBitrate );

	ScreenToClient( &rectBtnBitrate );

	// CREATE MAIN BITRATE COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainBitrate[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_BITRATE_CH01 +  i );

		m_comboxMainBitrate[ i ].MoveWindow( rectBtnBitrate.left, rectBtnBitrate.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastBitrateBottom = rectBtnBitrate.bottom + ( i * nItemHeight );

		for ( ULONG j = 0 ; j < m_strVecNtscBitrate.size() ; j++ )
		{
			m_comboxMainBitrate[ i ].AddString( m_strVecNtscBitrate[ j ].c_str() );
		}

		CRect rc; m_comboxMainBitrate[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainBitrate[ i ].MoveWindow(&rc); 

		m_comboxMainBitrate[ i ].ShowWindow( SW_SHOW );

		m_comboxMainBitrate[ i ].EnableWindow( FALSE );

		m_comboxMainBitrate[ i ].SetCurSel( 4 );
	}

	 rectBtnBitrate.bottom = nLastBitrateBottom + nItemHeight;

	// CREATE SUB BITRATE COMBOBOX
	//
	 if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubBitrate[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_BITRATE_CH01_SUB +  i );

			m_comboxSubBitrate[ i ].MoveWindow( rectBtnBitrate.left, rectBtnBitrate.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastBitrateBottom = rectBtnBitrate.bottom + ( i * nItemHeight );

			for ( ULONG j = 0 ; j < m_strVecNtscBitrate.size() ; j++ )
			{
				m_comboxSubBitrate[ i ].AddString( m_strVecNtscBitrate[ j ].c_str() );
			}

			CRect rc; m_comboxSubBitrate[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubBitrate[ i ].MoveWindow(&rc); 

			m_comboxSubBitrate[ i ].ShowWindow( SW_SHOW );

			m_comboxSubBitrate[ i ].EnableWindow( FALSE );

			m_comboxSubBitrate[ i ].SetCurSel( 4 );
		}
	 }

	HWND hBtnQuality = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_QUALITY );

	RECT rectBtnQuality;

	::GetWindowRect( hBtnQuality, &rectBtnQuality );

	ScreenToClient( &rectBtnQuality );

	// CREATE MAIN BITRATE COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainQuality[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_QUALITY_CH01 +  i );

		m_comboxMainQuality[ i ].MoveWindow( rectBtnQuality.left, rectBtnQuality.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastQualityBottom = rectBtnQuality.bottom + ( i * nItemHeight );

		for ( ULONG j = 0 ; j < m_strVecNtscQuality.size() ; j++ )
		{
			m_comboxMainQuality[ i ].AddString( m_strVecNtscQuality[ j ].c_str() );
		}

		CRect rc; m_comboxMainQuality[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainQuality[ i ].MoveWindow(&rc); 

		m_comboxMainQuality[ i ].ShowWindow( SW_SHOW );

		m_comboxMainQuality[ i ].SetCurSel( 4 );
	}

	 rectBtnQuality.bottom = nLastQualityBottom + nItemHeight;

	// CREATE SUB BITRATE COMBOBOX
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubQuality[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_QUALITY_CH01_SUB +  i );

			m_comboxSubQuality[ i ].MoveWindow( rectBtnQuality.left, rectBtnQuality.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastQualityBottom = rectBtnQuality.bottom + ( i * nItemHeight );

			for ( ULONG j = 0 ; j < m_strVecNtscQuality.size() ; j++ )
			{
				m_comboxSubQuality[ i ].AddString( m_strVecNtscQuality[ j ].c_str() );
			}

			CRect rc; m_comboxSubQuality[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubQuality[ i ].MoveWindow(&rc); 

			m_comboxSubQuality[ i ].ShowWindow( SW_SHOW );

			m_comboxSubQuality[ i ].SetCurSel( 4 );
		}
	}

	HWND hBtnGop = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_GOP );

	RECT rectBtnGop;

	::GetWindowRect( hBtnGop, &rectBtnGop );

	ScreenToClient( &rectBtnGop );

	// CREATE MAIN BITRATE COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainGop[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_GOP_CH01 +  i );

		m_comboxMainGop[ i ].MoveWindow( rectBtnGop.left, rectBtnGop.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastGopBottom = rectBtnGop.bottom + ( i * nItemHeight );

		CString strJ;

		for ( ULONG j = 0 ; j < 255 ; j++ )
		{
			strJ.Format( "%d", j + 1 );

			m_comboxMainGop[ i ].AddString( strJ );
		}

		CRect rc; m_comboxMainGop[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainGop[ i ].MoveWindow(&rc); 

		m_comboxMainGop[ i ].ShowWindow( SW_SHOW );

		m_comboxMainGop[ i ].SetCurSel( 29 );
	}

	 rectBtnGop.bottom = nLastGopBottom + nItemHeight;

	// CREATE SUB BITRATE COMBOBOX
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubGop[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_GOP_CH01_SUB +  i );

			m_comboxSubGop[ i ].MoveWindow( rectBtnGop.left, rectBtnGop.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastGopBottom = rectBtnGop.bottom + ( i * nItemHeight );

			CString strJ;

			for ( ULONG j = 0 ; j < 255 ; j++ )
			{
				strJ.Format( "%d", j + 1 );

				m_comboxSubGop[ i ].AddString( strJ );
			}

			CRect rc; m_comboxSubGop[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubGop[ i ].MoveWindow(&rc); 

			m_comboxSubGop[ i ].ShowWindow( SW_SHOW );

			m_comboxSubGop[ i ].SetCurSel( 29 );
		}
	}

	HWND hBtnBFrame = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_BFRAME );

	RECT rectBtnBFrame;

	::GetWindowRect( hBtnBFrame, &rectBtnBFrame );

	ScreenToClient( &rectBtnBFrame );

	// CREATE MAIN BFRAME COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainBFrame[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_BFRAME_CH01 +  i );

		m_comboxMainBFrame[ i ].MoveWindow( rectBtnBFrame.left, rectBtnBFrame.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastBFrameBottom = rectBtnBFrame.bottom + ( i * nItemHeight );

		CString strJ;

		for ( ULONG j = 0 ; j < 3 ; j++ )
		{
			strJ.Format( "%d", j );

			m_comboxMainBFrame[ i ].AddString( strJ );
		}

		CRect rc; m_comboxMainBFrame[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainBFrame[ i ].MoveWindow(&rc); 

		m_comboxMainBFrame[ i ].ShowWindow( SW_SHOW );		

		m_comboxMainBFrame[ i ].SetCurSel( 0 );

		if ( !m_bHasBFrame ) { m_comboxMainBFrame[ i ].EnableWindow( FALSE ); }
	}

	 rectBtnBFrame.bottom = nLastBFrameBottom + nItemHeight;

	// CREATE SUB BFRAME COMBOBOX
	//
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubBFrame[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_BFRAME_CH01_SUB +  i );

			m_comboxSubBFrame[ i ].MoveWindow( rectBtnBFrame.left, rectBtnBFrame.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastBFrameBottom = rectBtnBFrame.bottom + ( i * nItemHeight );

			CString strJ;

			for ( ULONG j = 0 ; j < 3 ; j++ )
			{
				strJ.Format( "%d", j );

				m_comboxSubBFrame[ i ].AddString( strJ );
			}

			CRect rc; m_comboxSubBFrame[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubBFrame[ i ].MoveWindow(&rc); 

			m_comboxSubBFrame[ i ].ShowWindow( SW_SHOW );

			m_comboxSubBFrame[ i ].SetCurSel( 0 );

			if ( !m_bHasBFrame ) { m_comboxSubBFrame[ i ].EnableWindow( FALSE ); }
		}
	}

	HWND hBtnVideoEncoder = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_VIDEO_ENCODER );

	RECT rectBtnVideoEncoder;

	::GetWindowRect( hBtnVideoEncoder, &rectBtnVideoEncoder );

	ScreenToClient( &rectBtnVideoEncoder );

	// CREATE MAIN VIDEO ENCODER COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainVideoEncoder[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_VIDEO_ENCODER_CH01 +  i );

		m_comboxMainVideoEncoder[ i ].MoveWindow( rectBtnVideoEncoder.left, rectBtnVideoEncoder.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastVideoEncoderBottom = rectBtnVideoEncoder.bottom + ( i * nItemHeight );

		m_comboxMainVideoEncoder[ i ].AddString( "H.264" );

		m_comboxMainVideoEncoder[ i ].AddString( "H.265" );

		CRect rc; m_comboxMainVideoEncoder[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainVideoEncoder[ i ].MoveWindow(&rc); 

		m_comboxMainVideoEncoder[ i ].ShowWindow( SW_SHOW );		

		m_comboxMainVideoEncoder[ i ].SetCurSel( 0 );
	}	

	 rectBtnVideoEncoder.bottom = nLastVideoEncoderBottom + nItemHeight;

	 // CREATE SUB VIDEO ENCODER COMBOBOX
	//
	 /*
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubVideoEncoder[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_VIDEO_ENCODER_CH01_SUB +  i );

			m_comboxSubVideoEncoder[ i ].MoveWindow( rectBtnVideoEncoder.left, rectBtnVideoEncoder.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastVideoEncoderBottom = rectBtnVideoEncoder.bottom + ( i * nItemHeight );

			m_comboxSubVideoEncoder[ i ].AddString( "H.264" );

			m_comboxSubVideoEncoder[ i ].AddString( "H.265" );

			CRect rc; m_comboxSubVideoEncoder[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubVideoEncoder[ i ].MoveWindow(&rc); 

			m_comboxSubVideoEncoder[ i ].ShowWindow( SW_SHOW );		

			m_comboxSubVideoEncoder[ i ].SetCurSel( 0 );
		}
	}
	*/

	HWND hBtnAudioEncoder = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_AUDIO_ENCODER );

	RECT rectBtnAudioEncoder;

	::GetWindowRect( hBtnAudioEncoder, &rectBtnAudioEncoder );

	ScreenToClient( &rectBtnAudioEncoder );

	// CREATE MAIN AUDIO ENCODER COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainAudioEncoder[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_AUDIO_ENCODER_CH01 +  i );

		m_comboxMainAudioEncoder[ i ].MoveWindow( rectBtnAudioEncoder.left, rectBtnAudioEncoder.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastAudioEncoderBottom = rectBtnAudioEncoder.bottom + ( i * nItemHeight );

		m_comboxMainAudioEncoder[ i ].AddString( "PCM" );

		m_comboxMainAudioEncoder[ i ].AddString( "AAC" );

		m_comboxMainAudioEncoder[ i ].AddString( "AAC.ADTS" );

		m_comboxMainAudioEncoder[ i ].AddString( "MP2" );

		m_comboxMainAudioEncoder[ i ].AddString( "MP3" );

		m_comboxMainAudioEncoder[ i ].AddString( "OPUS" );

		CRect rc; m_comboxMainAudioEncoder[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainAudioEncoder[ i ].MoveWindow(&rc); 

		m_comboxMainAudioEncoder[ i ].ShowWindow( SW_SHOW );		

		m_comboxMainAudioEncoder[ i ].SetCurSel( 1 );
	}	

	 rectBtnAudioEncoder.bottom = nLastAudioEncoderBottom + nItemHeight;

	// CREATE SUB AUDIO ENCODER COMBOBOX
	//
	 /*
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubAudioEncoder[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_AUDIO_ENCODER_CH01_SUB +  i );

			m_comboxSubAudioEncoder[ i ].MoveWindow( rectBtnAudioEncoder.left, rectBtnAudioEncoder.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastAudioEncoderBottom = rectBtnAudioEncoder.bottom + ( i * nItemHeight );

			m_comboxSubAudioEncoder[ i ].AddString( "PCM" );

			m_comboxSubAudioEncoder[ i ].AddString( "AAC" );

			m_comboxSubAudioEncoder[ i ].AddString( "AAC.ADTS" );

			m_comboxSubAudioEncoder[ i ].AddString( "MP2" );

			m_comboxSubAudioEncoder[ i ].AddString( "MP3" );

			m_comboxSubAudioEncoder[ i ].AddString( "OPUS" );

			CRect rc; m_comboxSubAudioEncoder[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubAudioEncoder[ i ].MoveWindow(&rc); 

			m_comboxSubAudioEncoder[ i ].ShowWindow( SW_SHOW );		

			m_comboxSubAudioEncoder[ i ].SetCurSel( 1 );
		}
	}	
	*/

	HWND hBtnFileType = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_FILE_TYPE );

	RECT rectBtnFileType;

	::GetWindowRect( hBtnFileType, &rectBtnFileType );

	ScreenToClient( &rectBtnFileType );

	// CREATE MAIN FILE TYPE COMBOBOX
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainFileType[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_FILE_TYPE_CH01 +  i );

		m_comboxMainFileType[ i ].MoveWindow( rectBtnFileType.left, rectBtnFileType.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

		nLastFileTypeBottom = rectBtnFileType.bottom + ( i * nItemHeight );

		m_comboxMainFileType[ i ].AddString( ".MP4" );

		m_comboxMainFileType[ i ].AddString( ".TS" );

		m_comboxMainFileType[ i ].AddString( ".ASF" );

		m_comboxMainFileType[ i ].AddString( ".WMV" );

		m_comboxMainFileType[ i ].AddString( ".FLV" );

		CRect rc; m_comboxMainFileType[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

		m_comboxMainFileType[ i ].MoveWindow(&rc); 

		m_comboxMainFileType[ i ].ShowWindow( SW_SHOW );		

		m_comboxMainFileType[ i ].SetCurSel( 0 );
	}	

	 rectBtnFileType.bottom = nLastFileTypeBottom + nItemHeight;

	 // CREATE SUB FILE TYPE COMBOBOX
	//
	 /*
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_comboxSubFileType[ i ].Create( WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_HASSTRINGS | WS_VSCROLL, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_COMBO_FILE_TYPE_CH01_SUB +  i );

			m_comboxSubFileType[ i ].MoveWindow( rectBtnFileType.left, rectBtnFileType.bottom + ( i * nItemHeight ), nItemWidth, nItemHeight );	

			nLastFileTypeBottom = rectBtnFileType.bottom + ( i * nItemHeight );

			m_comboxSubFileType[ i ].AddString( ".MP4" );

			m_comboxSubFileType[ i ].AddString( ".TS" );

			m_comboxSubFileType[ i ].AddString( ".ASF" );

			m_comboxSubFileType[ i ].AddString( ".WMV" );

			m_comboxSubFileType[ i ].AddString( ".FLV" );

			CRect rc; m_comboxSubFileType[ i ].GetWindowRect(&rc); ScreenToClient( &rc ); rc.bottom = rc.top + 200;

			m_comboxSubFileType[ i ].MoveWindow(&rc); 

			m_comboxSubFileType[ i ].ShowWindow( SW_SHOW );		

			m_comboxSubFileType[ i ].SetCurSel( 0 );
		}
	}	
	*/

	HWND hBtnStartRecord = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_START_RECORD );

	RECT rectBtnStartRecord;

	::GetWindowRect( hBtnStartRecord, &rectBtnStartRecord );

	ScreenToClient( &rectBtnStartRecord );

	// CREATE MAIN START RECORD BUTTON
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_btnMainStartRecord[ i ].Create( NULL, WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_BTN_START_RECORD_CH01 +  i );

		m_btnMainStartRecord[ i ].MoveWindow( rectBtnStartRecord.left + 2, rectBtnStartRecord.bottom + ( i * nItemHeight ) + 2, nItemWidth, nItemHeight );	

		nLastStartRecordBottom = rectBtnStartRecord.bottom + ( i * nItemHeight );	

		m_btnMainStartRecord[ i ].SetWindowText( "START" );

		m_btnMainStartRecord[ i ].ShowWindow( SW_SHOW );		
	}	

	 rectBtnStartRecord.bottom = nLastStartRecordBottom + nItemHeight;

	// CREATE SUB START RECORD BUTTON
	//
	 /*
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_btnSubStartRecord[ i ].Create( NULL, WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_BTN_START_RECORD_CH01_SUB +  i );

			m_btnSubStartRecord[ i ].MoveWindow( rectBtnStartRecord.left + 2, rectBtnStartRecord.bottom + ( i * nItemHeight ) + 2, nItemWidth, nItemHeight );	

			nLastStartRecordBottom = rectBtnStartRecord.bottom + ( i * nItemHeight );		

			m_btnSubStartRecord[ i ].SetWindowText( "START" );

			m_btnSubStartRecord[ i ].ShowWindow( SW_SHOW );		
		}	
	}
	*/

	HWND hBtnStopRecord = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_STOP_RECORD );

	RECT rectBtnStopRecord;

	::GetWindowRect( hBtnStopRecord, &rectBtnStopRecord );

	ScreenToClient( &rectBtnStopRecord );

	// CREATE MAIN STOP RECORD BUTTON
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_btnMainStoptRecord[ i ].Create( NULL, WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_BTN_STOP_RECORD_CH01 +  i );

		m_btnMainStoptRecord[ i ].MoveWindow( rectBtnStopRecord.left + 2, rectBtnStopRecord.bottom + ( i * nItemHeight ) + 2, nItemWidth, nItemHeight );	

		nLastStopRecordBottom = rectBtnStopRecord.bottom + ( i * nItemHeight );	

		m_btnMainStoptRecord[ i ].SetWindowText( "STOP" );

		m_btnMainStoptRecord[ i ].ShowWindow( SW_SHOW );

		m_btnMainStoptRecord[ i ].EnableWindow( FALSE );		
	}	

	 rectBtnStopRecord.bottom = nLastStopRecordBottom + nItemHeight;

	 // CREATE SUB STOP RECORD BUTTON
	//
	 /*
	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			m_btnSubStopRecord[ i ].Create( NULL, WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_BTN_STOP_RECORD_CH01_SUB +  i );			

			m_btnSubStopRecord[ i ].MoveWindow( rectBtnStopRecord.left + 2, rectBtnStopRecord.bottom + ( i * nItemHeight ) + 2, nItemWidth, nItemHeight );	

			nLastStopRecordBottom = rectBtnStopRecord.bottom + ( i * nItemHeight );		

			m_btnSubStopRecord[ i ].SetWindowText( "STOP" );

			m_btnSubStopRecord[ i ].ShowWindow( SW_SHOW );

			m_btnSubStopRecord[ i ].EnableWindow( FALSE );
		}	
	}	
	*/

	 HWND hBtnScheduleRecord = ::GetDlgItem( GetSafeHwnd(), IDC_EDIT_SCHEDULE_RECORD );

	RECT rectBtnScheduleRecord;

	::GetWindowRect( hBtnScheduleRecord, &rectBtnScheduleRecord );

	ScreenToClient( &rectBtnScheduleRecord );

	// CREATE MAIN SCHEDULE RECORD BUTTON
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_btnMainScheduleRecord[ i ].Create( NULL, WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, CRect( 0 , 0 , nItemWidth, nItemHeight), this, IDC_BTN_SCHEDULE_RECORD_CH01 +  i );

		m_btnMainScheduleRecord[ i ].MoveWindow( rectBtnScheduleRecord.left + 2, rectBtnScheduleRecord.bottom + ( i * nItemHeight ) + 2, nItemWidth, nItemHeight );	

		nLastStopRecordBottom = rectBtnScheduleRecord.bottom + ( i * nItemHeight );	

		m_btnMainScheduleRecord[ i ].SetWindowText( "SCHEDULE" );

		m_btnMainScheduleRecord[ i ].ShowWindow( SW_SHOW );

		m_btnMainScheduleRecord[ i ].EnableWindow( TRUE );
	}	

	 /*
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		OnMainRecordModeSelectChange( IDC_COMBO_RECORDMODE_CH01 +  i );
	}	 

	if ( m_bHasSubStream )
	{
		for ( i = 0 ; i < m_nCHNum ; i++ )
		{
			OnSubRecordModeSelectChange( IDC_COMBO_RECORDMODE_CH01_SUB +  i );
		}
	}
	*/

	// MOVE SETUP DIALOG POSITION
	//
	RECT rectSetup;

	GetWindowRect( &rectSetup );

	ULONG nSetupWidth = rectSetup.right - rectSetup.left;

	ULONG nSetupHeight = rectSetup.bottom - rectSetup.top;	

	MoveWindow( rectSetup.left, rectSetup.top, nSetupWidth, rectBtnChannel.bottom + 40 );

	// CREATE FILE RENDERER
	//
	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		m_pMainFileRenderer[ i ] = new CFileRenderer();

		m_pMainFileRenderer[ i ]->m_hWnd = this->GetSafeHwnd();
	}	

	// LOAD SCHEDULE DATA
	//	
	CString strScheduleFile;

	strScheduleFile.Format( "%s", GetWorkingPath( "SCHEDULE.TXT" ) );

	if( !IsFileExists( strScheduleFile.GetBuffer( 256 ) ) ) 
	{  
		strScheduleFile.ReleaseBuffer();

		return TRUE;  
	}

	strScheduleFile.ReleaseBuffer();

	CStdioFile * pTxtFile = NULL;

	pTxtFile = new CStdioFile( strScheduleFile,  CFile::modeRead | CFile::typeText );	

	if ( pTxtFile != NULL )
	{
		CString strLine;

		while( pTxtFile->ReadString( strLine ) )
		{
			CStringVector strVector = SplitString(strLine, ",", true);

			ULONG nCH = 0;

			SCHEDULE_INFO s_schedule_info;	

			ULONGLONG nStartTime = 0, nStopTime = 0;

			ULONG nWeeklyDay = 0;

			if ( strVector.size() >= 4 )
			{
				nCH = atoi( strVector[ 0 ] );

				s_schedule_info.nFrequencyType = atoi( strVector[ 1 ] );

				std::string str1 = strVector[ 2 ];

				s_schedule_info.nStartTime = nStartTime = stoull( str1, 0, 10 );

				SYSTEMTIME	timeStart;  FileTimeToSystemTime( (FILETIME *)(&nStartTime), &timeStart);

				s_schedule_info.sStartTime = timeStart;

				std::string str2 = strVector[ 3 ];

				s_schedule_info.nStopTime = nStopTime = stoull( str2, 0, 10 );

				SYSTEMTIME	timeStop;  FileTimeToSystemTime( (FILETIME *)(&nStopTime), &timeStop);

				s_schedule_info.sStopTime = timeStop;

				if ( s_schedule_info.nFrequencyType == 2 )
				{
					nWeeklyDay =  atoi( strVector[ 4 ] );

					s_schedule_info.nWeeklyDay = nWeeklyDay;
				}

				s_schedule_info.nSkip = 0x00000000;

				s_schedule_info.bIsRecording = FALSE;

				m_oSchduleRecordDlg.m_oScheduleArray[ nCH ].Add( s_schedule_info );				
			}
		}

		pTxtFile->Close();

		delete pTxtFile;

		pTxtFile = NULL;
	}	

	SetTimer( 0x00000001, 1000, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetupDialog::OnDestroy() 
{
	KillTimer( 0x00000001 );

	ULONG i = 0, j = 0;

	// STOP RECORDING
	//
	for ( i = 0 ; i < MAX_CHANNEL ; i++ )
	{
		if ( m_pMainFileRenderer[ i ] != NULL )
		{
			if( m_pMainFileRenderer[ i ]->m_nMainFileRendererRecordState >= 0x00000001 ) 
			{
				m_pMainFileRenderer[ i ]->StopRecording();
			}
		}
	}
	
	// DELETE FILE RENDERER
	//
	for ( i = 0 ; i < MAX_CHANNEL ; i++ )
	{
		if ( m_pMainFileRenderer[ i ] != NULL )
		{
			delete m_pMainFileRenderer[ i ];

			m_pMainFileRenderer[ i ] = NULL;
		}
	}

	UnInitResource();

	SCHEDULE_INFO s_schedule_info;

	ULONG nFrequencyType = 0, nDayOfWeek = 0;

	ULONGLONG nStartTime = 0, nStopTime = 0;

	CString strLine;

	// WRITE SCHEDULE DATA
	//
	CString strScheduleFile;

	strScheduleFile.Format( "%s", GetWorkingPath( "SCHEDULE.TXT" ) );

	CStdioFile * pTxtFile = NULL;

	pTxtFile = new CStdioFile( strScheduleFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeText );	

	if ( pTxtFile == NULL ) return;

	for ( i = 0 ; i < m_nCHNum ; i++ )
	{
		for( j = 0 ; j < m_oSchduleRecordDlg.m_oScheduleArray[ i ].GetSize() ; j++ )
		{
			s_schedule_info = m_oSchduleRecordDlg.m_oScheduleArray[ i ].ElementAt( j );

			nFrequencyType = s_schedule_info.nFrequencyType;			

			ULONGLONG nStartTime = 0; 
	
			SystemTimeToFileTime( &s_schedule_info.sStartTime, (FILETIME *)(&nStartTime) );	

			ULONGLONG nStopTime = 0; 
	
			SystemTimeToFileTime( &s_schedule_info.sStopTime, (FILETIME *)(&nStopTime) );	

			nDayOfWeek = s_schedule_info.nWeeklyDay;

			if ( nFrequencyType == 2 )
			{
				strLine.Format( "%d,%d,%I64d,%I64d,%d\n", i,  nFrequencyType, nStartTime, nStopTime, nDayOfWeek );
			}
			else
			{
				strLine.Format( "%d,%d,%I64d,%I64d\n", i,  nFrequencyType, nStartTime, nStopTime );
			}

			pTxtFile->WriteString( strLine );
		}
	}	

	pTxtFile->Close();

	delete pTxtFile;

	pTxtFile = NULL;

	CString strFile;

	strFile.Format( "%s", GetWorkingPath( "PREVIEW.TXT" ) );

	if( IsFileExists( strFile.GetBuffer( 256 ) ) ) 
	{  
		DeleteFile( strFile );

		strFile.ReleaseBuffer();		
	}
}

BOOL CSetupDialog::InitResource()
{
	// GET MY MODULE HANDLE
	//
	HINSTANCE hMyMoudleInst = GetMyModuleHandle();

	if (hMyMoudleInst == NULL) 
	{ 
		DumpDebugMessage( "GetMyModuleHandle fail ! \n" );

		return FALSE; 
	}

	CString strDeviceName = m_pszDevName;

	HRSRC hRsrc = NULL;

	if ( strDeviceName == "FH8735 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_87351), TEXT("TEXT_8735"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_87351 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "AH8400 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_84001), TEXT("TEXT_8400"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_84001 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "SA7160 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_71601), TEXT("TEXT_7160"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_71601 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "TW6802 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_68021), TEXT("TEXT_6802"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_68021 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "TW5864 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_58641), TEXT("TEXT_5864"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_58641 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "TW2809 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_28091), TEXT("TEXT_2809"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_58641 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "CX2581 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_25811), TEXT("TEXT_2581"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_25811 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "MZ0380 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_03801), TEXT("TEXT_0380"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_25811 fail ! \n" ); return FALSE;  }
	}

	if ( strDeviceName == "QP0203 PCI" )
	{
		hRsrc = FindResource(hMyMoudleInst, MAKEINTRESOURCE(IDR_TEXT_02031), TEXT("TEXT_0203"));

		if (hRsrc == NULL) {  DumpDebugMessage( "FindResource IDR_TEXT_02031 fail ! \n" ); return FALSE;  }
	}

	m_dwTxtDataSize = SizeofResource( hMyMoudleInst, hRsrc ); 

	HGLOBAL hGlobal = LoadResource( hMyMoudleInst, hRsrc ); 

	LPVOID pdata = LockResource(hGlobal);

	LPBYTE sData = (LPBYTE)pdata;
		
	m_strTxtData.Format("%s", sData);	

	FreeResource( hGlobal );

	m_strDeviceName = strDeviceName;

	strDeviceName.Replace( " PCI", ".TXT" );

	// WRITE TXT DATA
	//
	CString strConfigFile;

	strConfigFile.Format( "%s", GetWorkingPath( strDeviceName ) );

	CStdioFile	*pTxtFile = NULL;

	pTxtFile = new CStdioFile( strConfigFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeText);	

	pTxtFile->Write( m_strTxtData, m_dwTxtDataSize );

	pTxtFile->Close();

	delete pTxtFile;

	pTxtFile = NULL;

	// READ RELATED INFO FROM TXT FILE
	//
	pTxtFile  = new CStdioFile( strConfigFile,  CFile::modeRead | CFile::typeText );

	if ( pTxtFile != NULL )
	{
		CString strLine, strSection;

		string strData;

		ULONG i = 0;

		while( pTxtFile->ReadString( strLine ) )
		{
			CStringVector strVector = SplitString(strLine, ";", true);

			if ( strVector.size() >= 2 )
			{		
				if ( strLine.Find( "NTSC.RESOLUTION.MAIN" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscRes.push_back( strData ); } }

				if ( strLine.Find( "NTSC.RESOLUTION.SUB" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscResSub.push_back( strData ); } }

				if ( strLine.Find( "NTSC.FRAMERATE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscFrameRate.push_back( strData ); } }

				if ( strLine.Find( "NTSC.RECORDMODE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscRecordMode.push_back( strData ); } }

				if ( strLine.Find( "NTSC.BITRATE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscBitrate.push_back( strData ); } }

				if ( strLine.Find( "NTSC.QUALITY" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscQuality.push_back( strData ); } }

				if ( strLine.Find( "NTSC.QPSTEP" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscQpstep.push_back( strData ); } }

				if ( strLine.Find( "NTSC.PEAKBITRATE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscPeakBitrate.push_back( strData ); } }

				if ( strLine.Find( "NTSC.TROUGHQUALITY" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecNtscThroughQuality.push_back( strData ); } }

				if ( strLine.Find( "PAL.RESOLUTION.MAIN" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalRes.push_back( strData ); } }

				if ( strLine.Find( "PAL.RESOLUTION.SUB" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalResSub.push_back( strData ); } }

				if ( strLine.Find( "PAL.FRAMERATE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalFrameRate.push_back( strData ); } }

				if ( strLine.Find( "PAL.RECORDMODE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalRecordMode.push_back( strData ); } }

				if ( strLine.Find( "PAL.BITRATE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalBitrate.push_back( strData ); } }

				if ( strLine.Find( "PAL.QUALITY" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalQuality.push_back( strData ); } }

				if ( strLine.Find( "PAL.QPSTEP" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalQpstep.push_back( strData ); } }

				if ( strLine.Find( "PAL.PEAKBITRATE" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalPeakBitrate.push_back( strData ); } }

				if ( strLine.Find( "PAL.TROUGHQUALITY" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecPalThroughQuality.push_back( strData ); } }

				if ( strLine.Find( "VIDEO.BFRAME" ) != -1 ) { for ( i = 1 ; i < strVector.size() - 1 ; i++ ) { strData = strVector[ i ]; m_strVecBFrame.push_back( strData ); } }
			}
		}
	}

	pTxtFile->Close();

	delete pTxtFile;

	pTxtFile = NULL;

	if ( m_strVecNtscResSub.size() > 0 )  { m_bHasSubStream = TRUE; }

	if ( m_strVecBFrame.size() > 0 )  { m_bHasBFrame = TRUE; }	

	return TRUE;
}

BOOL CSetupDialog::UnInitResource()
{
	ULONG i = 0;

	for ( i = 0 ; i < MAX_CHANNEL ; i++ )
	{
		DeleteCriticalSection( &m_oSchduleRecordDlg.m_hScheduleArrayAccessCriticalSection[ i ] );
	}

	return TRUE;
}

void CSetupDialog::OnSelChangeComboStandard() 
{
	// TODO: Add your control notification handler code here

	ULONG nSel = m_comboStandard.GetCurSel();

	for ( ULONG i = 0 ; i < m_nCHNum ; i++ )
	{
		m_comboxMainResolution[ i ].ResetContent();		

		m_comboxMainFrameRate[ i ].ResetContent();

		if ( m_bHasSubStream )
		{
			m_comboxSubResolution[ i ].ResetContent();	

			m_comboxSubFrameRate[ i ].ResetContent();
		}
	}

	// NTSC
	//
	if( nSel == 0 ) 
	{
		for ( ULONG i = 0 ; i < m_nCHNum ; i++ )
		{
			for ( ULONG j = 0 ; j < m_strVecNtscRes.size() ; j++ )
			{
				m_comboxMainResolution[ i ].AddString( m_strVecNtscRes[ j ].c_str() );
			}

			m_comboxMainResolution[ i ].SetCurSel( 0 );

			for ( ULONG j = 0 ; j < m_strVecNtscFrameRate.size() ; j++ )
			{
				m_comboxMainFrameRate[ i ].AddString( m_strVecNtscFrameRate[ j ].c_str() );
			}		

			m_comboxMainFrameRate[ i ].SetCurSel( 0 );

			if ( m_bHasSubStream )
			{
				for ( ULONG j = 0 ; j < m_strVecNtscResSub.size() ; j++ )
				{
					m_comboxSubResolution[ i ].AddString( m_strVecNtscResSub[ j ].c_str() );
				}

				m_comboxSubResolution[ i ].SetCurSel( 0 );

				for ( ULONG j = 0 ; j < m_strVecNtscFrameRate.size() ; j++ )
				{
					m_comboxSubFrameRate[ i ].AddString( m_strVecNtscFrameRate[ j ].c_str() );
				}

				m_comboxSubFrameRate[ i ].SetCurSel( 0 );
			}
		}
	}

	// PAL
	//
	if( nSel == 1 ) 
	{
		for ( ULONG i = 0 ; i < m_nCHNum ; i++ )
		{
			for ( ULONG j = 0 ; j < m_strVecPalRes.size() ; j++ )
			{
				m_comboxMainResolution[ i ].AddString( m_strVecPalRes[ j ].c_str() );
			}

			m_comboxMainResolution[ i ].SetCurSel( 0 );

			for ( ULONG j = 0 ; j < m_strVecPalFrameRate.size() ; j++ )
			{
				m_comboxMainFrameRate[ i ].AddString( m_strVecPalFrameRate[ j ].c_str() );
			}		

			m_comboxMainFrameRate[ i ].SetCurSel( 0 );

			if ( m_bHasSubStream )
			{
				for ( ULONG j = 0 ; j < m_strVecPalResSub.size() ; j++ )
				{
					m_comboxSubResolution[ i ].AddString( m_strVecPalResSub[ j ].c_str() );
				}

				m_comboxSubResolution[ i ].SetCurSel( 0 );

				for ( ULONG j = 0 ; j < m_strVecPalFrameRate.size() ; j++ )
				{
					m_comboxSubFrameRate[ i ].AddString( m_strVecPalFrameRate[ j ].c_str() );
				}

				m_comboxSubFrameRate[ i ].SetCurSel( 0 );
			}
		}
	}
}

CStringVector CSetupDialog::SplitString(const CString& strSource, const CString& delim, bool bRemoveNone)
{
	CStringVector strRows;

	int nStart = 0;

	int delimLen = delim.GetLength();

	int nPos = strSource.Find(delim, nStart);

	while(nPos >= 0)
	{	
		if(bRemoveNone) 
		{
			if(nPos > nStart)
			{
				strRows.push_back(strSource.Mid(nStart, nPos - nStart));	
			}
		}
		else 
		{
			strRows.push_back(strSource.Mid(nStart, nPos - nStart));		
		}

		nStart = nPos + delimLen;

		nPos = strSource.Find(delim, nStart);	
	}	
	
	int length = strSource.GetLength();

	if(bRemoveNone)
	{
		if(length > nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	} 
	else
	{
		if(length >= nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	}

	return strRows;
}

CString CSetupDialog::GetWorkingPath( CString strWorkFile )
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += strWorkFile;

	return strCurPath;
}

void CSetupDialog::OnMainRecordModeSelectChange(UINT nID)
{
	int nCH = nID - IDC_COMBO_RECORDMODE_CH01;

	int nSel = m_comboxMainRecordMode[ nCH ].GetCurSel();

	if ( nSel == 0 )
	{
		m_comboxMainBitrate[ nCH ].EnableWindow( FALSE );

		m_comboxMainQuality[ nCH ].EnableWindow( TRUE );		
	}
	else if ( nSel == 1 )
	{
		m_comboxMainBitrate[ nCH ].EnableWindow( TRUE );

		m_comboxMainQuality[ nCH ].EnableWindow( FALSE );		
	}
	else
	{
		m_comboxMainBitrate[ nCH ].EnableWindow( TRUE );

		m_comboxMainQuality[ nCH ].EnableWindow( TRUE );	
	}
}

void CSetupDialog::OnSubRecordModeSelectChange(UINT nID)
{
	int nCH = nID - IDC_COMBO_RECORDMODE_CH01_SUB;

	int nSel =  m_comboxSubRecordMode[ nCH ].GetCurSel();

	if ( nSel == 0 )
	{
		m_comboxSubBitrate[ nCH ].EnableWindow( FALSE );

		m_comboxSubQuality[ nCH ].EnableWindow( TRUE );
	}
	else if ( nSel == 1 )
	{
		m_comboxSubBitrate[ nCH ].EnableWindow( TRUE );

		m_comboxSubQuality[ nCH ].EnableWindow( FALSE );		
	}
	else
	{
		m_comboxSubBitrate[ nCH ].EnableWindow( TRUE );

		m_comboxSubQuality[ nCH ].EnableWindow( TRUE );
	}
}

void CSetupDialog::OnMainStartRecord(UINT nID)
{	
	int nCH = nID - IDC_BTN_START_RECORD_CH01;

	if ( m_oSchduleRecordDlg.m_oScheduleArray[ nCH ].GetSize() > 0 )
	{ 
		AfxMessageBox( "Please clear schedule record list !" );

		return; 
	}
	else
	{
		m_bManualRecord[ nCH ] = TRUE;
	}

	StartRecordimg( nID, FALSE );
}

void CSetupDialog::OnMainStopRecord(UINT nID)
{
	int nCH = nID - IDC_BTN_STOP_RECORD_CH01;

	if ( m_bManualRecord[ nCH ] == TRUE )
	{
		m_bManualRecord[ nCH ] = FALSE;

		StopRecordimg( nID );

		return;
	}

	if ( m_oSchduleRecordDlg.m_oScheduleArray[ nCH ].GetSize() > 0 ) 
	{ 
		AfxMessageBox( "Please clear schedule record list !" );

		return; 
	}
	
	StopRecordimg( nID );
}

VOID CSetupDialog::StartRecordimg( UINT nID, BOOL bSchedule )
{	
	int nCH = nID - IDC_BTN_START_RECORD_CH01;	

	m_btnMainStartRecord[ nCH ].EnableWindow( FALSE );

	m_btnMainStoptRecord[ nCH ].EnableWindow( TRUE );

	//m_bRecordManually[ nCH ] = TRUE;

	//m_bStopManually[ nCH ] = FALSE;

	m_pMainFileRenderer[ nCH ]->m_nCH = nCH;

	int nSelStandard = m_comboStandard.GetCurSel();

	if ( nSelStandard == 1 )
		m_pMainFileRenderer[ nCH ]->m_nVideoStandard = VIDEO_PAL;
	else
		m_pMainFileRenderer[ nCH ]->m_nVideoStandard = VIDEO_NTSC;	

	int nSelVideoEncoder = m_comboxMainVideoEncoder[ nCH ].GetCurSel();

	int nSelAudioEncoder = m_comboxMainAudioEncoder[ nCH ].GetCurSel();

	int nSelFileType = m_comboxMainFileType[ nCH ].GetCurSel();

	int nSelMainRecordMode = m_comboxMainRecordMode[ nCH ].GetCurSel();

	int nSelMainGop= m_comboxMainGop[ nCH ].GetCurSel();

	int nSelMainBFrame= m_comboxMainBFrame[ nCH ].GetCurSel();

	int nSelMainQuality= m_comboxMainQuality[ nCH ].GetCurSel();

	int nSelMainBitrate= m_comboxMainBitrate[ nCH ].GetCurSel();

	int nSelMainDeinterlace = m_comboxMainDeinterlace[ nCH ].GetCurSel();

	int nSelMainFramerate = m_comboxMainFrameRate[ nCH ].GetCurSel();

	int nSelMainResolution = m_comboxMainResolution[ nCH ].GetCurSel();		

	CString strMainFramerate; double dMainFramerate = 0.0;

	m_comboxMainFrameRate[ nCH ].GetLBText( nSelMainFramerate , strMainFramerate );

	dMainFramerate = atof( strMainFramerate );

	CString strMainResolution;

	m_comboxMainResolution[ nCH ].GetLBText( nSelMainResolution , strMainResolution );

	CStringVector strVectorMain = SplitString(strMainResolution, "X", true);

	m_pMainFileRenderer[ nCH ]->m_nMainFrameWidth = atoi( strVectorMain[ 0 ] );

	m_pMainFileRenderer[ nCH ]->m_nMainFrameHeight = atoi( strVectorMain[ 1 ] );

	if ( m_bHasSubStream )
	{
		int nSelSubRecordMode = m_comboxSubRecordMode[ nCH ].GetCurSel();

		int nSelSubGop= m_comboxSubGop[ nCH ].GetCurSel();

		int nSelSubBFrame= m_comboxSubBFrame[ nCH ].GetCurSel();

		int nSelSubQuality= m_comboxSubQuality[ nCH ].GetCurSel();

		int nSelSubBitrate= m_comboxSubBitrate[ nCH ].GetCurSel();

		int nSelSubDeinterlace = m_comboxSubDeinterlace[ nCH ].GetCurSel();

		int nSelSubFramerate = m_comboxSubFrameRate[ nCH ].GetCurSel();

		int nSelSubResolution = m_comboxSubResolution[ nCH ].GetCurSel();	

		CString strSubFramerate; double dSubFramerate = 0.0;

		m_comboxSubFrameRate[ nCH ].GetLBText( nSelSubFramerate , strSubFramerate );

		dSubFramerate = atof( strSubFramerate );

		CString strSubResolution;

		m_comboxSubResolution[ nCH ].GetLBText( nSelSubResolution , strSubResolution );

		CStringVector strVectorSub = SplitString(strSubResolution, "X", true);	
	
		m_pMainFileRenderer[ nCH ]->m_nSubFrameWidth = atoi( strVectorSub[ 0 ] );

		m_pMainFileRenderer[ nCH ]->m_nSubFrameHeight = atoi( strVectorSub[ 1 ] );

		m_pMainFileRenderer[ nCH ]->m_nSubFrameRate = dSubFramerate;

		m_pMainFileRenderer[ nCH ]->m_nSubRecordMode = nSelSubRecordMode;

		m_pMainFileRenderer[ nCH ]->m_nSubGOP = nSelSubGop + 1;

		m_pMainFileRenderer[ nCH ]->m_nSubBFrame = nSelSubBFrame;

		m_pMainFileRenderer[ nCH ]->m_nSubDeinterlace = nSelSubDeinterlace;

		m_pMainFileRenderer[ nCH ]->m_nSubQuality = m_pMainFileRenderer[ nCH ]->m_nSubQualityMatrix[ nSelSubQuality ];

		m_pMainFileRenderer[ nCH ]->m_nSubBitRate = m_pMainFileRenderer[ nCH ]->m_nSubBitRateMatrix[ nSelSubBitrate ];
	}

	m_pMainFileRenderer[ nCH ]->m_nMainFrameRate = dMainFramerate;

	m_pMainFileRenderer[ nCH ]->m_nMainRecordMode = nSelMainRecordMode;

	m_pMainFileRenderer[ nCH ]->m_nMainGOP = nSelMainGop + 1;

	m_pMainFileRenderer[ nCH ]->m_nMainBFrame = nSelMainBFrame;

	m_pMainFileRenderer[ nCH ]->m_nMainDeinterlace = nSelMainDeinterlace;

	m_pMainFileRenderer[ nCH ]->m_nMainQuality = m_pMainFileRenderer[ nCH ]->m_nMainQualityMatrix[ nSelMainQuality ];

	m_pMainFileRenderer[ nCH ]->m_nMainBitRate = m_pMainFileRenderer[ nCH ]->m_nMainBitRateMatrix[ nSelMainBitrate ];

	m_pMainFileRenderer[ nCH ]->m_nVideoEncoderType = nSelVideoEncoder;

	m_pMainFileRenderer[ nCH ]->m_nAudioEncoderType = nSelAudioEncoder;

	m_pMainFileRenderer[ nCH ]->m_nFileType = nSelFileType;

	m_pMainFileRenderer[ nCH ]->m_strChipName = m_strDeviceName;	

	m_pMainFileRenderer[ nCH ]->m_bIsSchedule = bSchedule;

	m_pMainFileRenderer[ nCH ]->StartRecording();	
}

VOID CSetupDialog::StopRecordimg( UINT nID )
{
	int nCH = nID - IDC_BTN_STOP_RECORD_CH01;	

	m_btnMainStartRecord[ nCH ].EnableWindow( TRUE );

	m_btnMainStoptRecord[ nCH ].EnableWindow( FALSE );

	//m_bRecordManually[ nCH ] = FALSE;

	//m_bStopManually[ nCH ] = TRUE;

	m_pMainFileRenderer[ nCH ]->StopRecording();	
}

void CSetupDialog::OnMainScheduleRecord(UINT nID)
{
	int nCH = nID - IDC_BTN_SCHEDULE_RECORD_CH01;

	m_oSchduleRecordDlg.m_nChannelID = nCH;

	if ( m_oSchduleRecordDlg.DoModal() == IDOK )
	{
		KillTimer( 0x00000001 );

		SetTimer( 0x00000001, 1000, NULL );
	}
}

BOOL CSetupDialog::CheckSchedule()
{
	ULONG x = 0, j = 0;

	SYSTEMTIME s_now_system_times; 

	ULONGLONG n_now_system_times;

	GetLocalTime( &s_now_system_times );

	SystemTimeToFileTime( &s_now_system_times, (FILETIME *)(&n_now_system_times) );
	
	BOOL  is_start_record_update[ 16 ] = {0};

	BOOL  is_stop_record_update[ 16 ] = {0};

	SCHEDULE_INFO s_schedule_info;

	for ( x = 0 ; x < m_nCHNum ; x++ )
	{
		//if( m_bRecordManually[ x ] == TRUE ) { continue; }

		if ( m_bManualRecord[ x ] == TRUE ) { continue; }

		EnterCriticalSection( &m_oSchduleRecordDlg.m_hScheduleArrayAccessCriticalSection[ x ] );

		is_start_record_update[ x ] = FALSE;

		is_stop_record_update[ x ] = FALSE;

		for( INT i = 0 ; i < m_oSchduleRecordDlg.m_oScheduleArray[ x ].GetSize() ; i++ ) 
		{
			j = i;

			s_schedule_info = m_oSchduleRecordDlg.m_oScheduleArray[ x ].ElementAt( i );

			ULONG nFrequencyType = s_schedule_info.nFrequencyType;

			// ONCE
			//
			if( nFrequencyType == 0x00000000 ) 
			{
				if( n_now_system_times >= s_schedule_info.nStartTime && 

					n_now_system_times <= s_schedule_info.nStopTime )
				{
					//if( m_bStopManually[ x ] == TRUE ) { m_oSchduleRecordDlg.m_oScheduleArray[ x ].ElementAt( i ).nSkip = 0x00000001; }

					if( s_schedule_info.nSkip == 0x00000000 ) 
					{ 
						// n_after_recording = s_schedule_info.nAfterRecording;

						is_start_record_update[ x ] = TRUE;

						break;
					}
				}
				else  if( n_now_system_times > s_schedule_info.nStopTime )
				{
					is_stop_record_update[ x ] = TRUE;

					break;
				}
			}

			// WEEKLY
			//
			if( nFrequencyType == 0x00000002 ) 
			{
				if( s_now_system_times.wDayOfWeek == s_schedule_info.sStartTime.wDayOfWeek ||
					
					s_now_system_times.wDayOfWeek == s_schedule_info.sStopTime.wDayOfWeek ) 
				{
					nFrequencyType = 0x00000003;
				}
			}

			// DAILY OR WEEKLY
			//
			if( nFrequencyType == 0x00000001 ||
			
				nFrequencyType == 0x00000003 ) 
			{
				SYSTEMTIME s_start_system_times = s_now_system_times;

				ULONGLONG n_start_system_times = 0;

				SYSTEMTIME s_stop_system_times = s_now_system_times;

				ULONGLONG n_stop_system_times = 0;

				s_start_system_times.wHour = s_schedule_info.sStartTime.wHour;

				s_start_system_times.wMinute = s_schedule_info.sStartTime.wMinute;

				s_start_system_times.wSecond = 0;

				s_start_system_times.wMilliseconds = 0;

				SystemTimeToFileTime( &s_start_system_times, (FILETIME *)(&n_start_system_times) );

				if( n_now_system_times >= n_start_system_times ) 
				{
					n_stop_system_times = n_start_system_times + ( s_schedule_info.nStopTime -s_schedule_info.nStartTime);

					if( nFrequencyType == 0x00000003 ) 
					{
						if( s_now_system_times.wDayOfWeek != s_schedule_info.sStartTime.wDayOfWeek ) {

							n_start_system_times = 0;

							n_stop_system_times = 0;
						}
					}
				}
				else 
				{
					if( nFrequencyType == 0x00000003 ) 
					{
						if( s_now_system_times.wDayOfWeek != s_schedule_info.sStopTime.wDayOfWeek ) 
						{
							n_start_system_times = 0;

							n_stop_system_times = 0;
						}
					}
					else 
					{
						s_stop_system_times.wHour = s_schedule_info.sStopTime.wHour;

						s_stop_system_times.wMinute = s_schedule_info.sStopTime.wMinute;

						s_stop_system_times.wSecond = 0;

						s_stop_system_times.wMilliseconds = 0;

						SystemTimeToFileTime( &s_stop_system_times, (FILETIME *)(&n_stop_system_times) );

						n_start_system_times = n_stop_system_times - ( s_schedule_info.nStopTime - s_schedule_info.nStartTime);
					}
				}

				if( n_now_system_times >= n_start_system_times && 

					n_now_system_times <= n_stop_system_times ) 
				{
					//if( m_bStopManually[ x ] == TRUE ) { s_schedule_info.nSkip = 0x00000001; }

					if( s_schedule_info.nSkip == 0x00000000 ) 
					{ 
						//n_after_recording = s_schedule_info.nAfterRecording;

						is_start_record_update[ x ] = TRUE;

						break;
					}
				}
				else if( n_now_system_times > n_stop_system_times ) 
				{
					if( s_schedule_info.nSkip == 0x00000001 ) 
					{
						s_schedule_info.nSkip = 0x00000000;
					}

					is_stop_record_update[ x ] = TRUE;	

					break;
				}
			}
		}	

		//if ( x == 2 )
		{
			//DumpDebugMessage( " is_start_record_update[ %d ] : %d, is_stop_record_update[ %d ] : %d ", x, is_start_record_update[ x ], x, is_stop_record_update[ x ]  );

			if( is_start_record_update[ x ] == TRUE ) 
			{ 
				// START RECORDING
				//
				//OnMainStartRecord( IDC_BTN_START_RECORD_CH01 + x );			

				s_schedule_info.bIsRecording = TRUE;

				m_oSchduleRecordDlg.m_oScheduleArray[ x ].SetAt( j, s_schedule_info );

				StartRecordimg( IDC_BTN_START_RECORD_CH01 + x, TRUE );

				//m_nScheduleAfterRecording = n_after_recording;
			}

			if( is_stop_record_update[ x ] == TRUE ) 
			{
				// STOP RECORDING
				//
				// OnMainStopRecord( IDC_BTN_STOP_RECORD_CH01 + x );

				m_pMainFileRenderer[ x ]->m_nMainFileRendererRecordState = 0;

				StopRecordimg( IDC_BTN_STOP_RECORD_CH01 + x );

				s_schedule_info.bIsRecording = FALSE;

				m_oSchduleRecordDlg.m_oScheduleArray[ x ].SetAt( j, s_schedule_info );
			}
		}		

		//m_bStopManually[ x ] = FALSE;

		LeaveCriticalSection( &m_oSchduleRecordDlg.m_hScheduleArrayAccessCriticalSection[ x ] );
	}
	
	return TRUE;
}

void CSetupDialog::OnRButtonDown(UINT nFlags, CPoint point) 
{	
	POINT point2;

	GetCursorPos( &point2 );

	//m_PopupMenu.TrackPopupMenu( TPM_LEFTALIGN | TPM_LEFTBUTTON, point2.x, point2.y, this);

	CDialogEx::OnRButtonDown(nFlags, point);
}

void CSetupDialog::OnScheduleRecord()
{	
	m_oSchduleRecordDlg.DoModal();
}

void CSetupDialog::OnTimer(UINT_PTR nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if ( 0x00000001 == nIDEvent )
	{
		// CHECK SCHEDULE RECORDING
		// 
		CheckSchedule();
	}

	CDialogEx::OnTimer(nIDEvent);
}

BOOL CSetupDialog::IsDirectoryExist(LPCTSTR szPath)
{    
	DWORD dwAttrib = GetFileAttributes(szPath);
	
	return (dwAttrib != INVALID_FILE_ATTRIBUTES && (dwAttrib & FILE_ATTRIBUTE_DIRECTORY));
}

BOOL CSetupDialog::IsFileExists(const TCHAR* pFile)
{
	WIN32_FIND_DATA FindFileData;

	HANDLE hFind = INVALID_HANDLE_VALUE;

	hFind = FindFirstFile(pFile, &FindFileData);

	if (hFind == INVALID_HANDLE_VALUE) 
	{	
		return FALSE;
	} 
	else 
	{
		FindClose(hFind);

		return TRUE;
	}
}

void CSetupDialog::OnSysCommand( UINT nID, LPARAM lParam ) 
{
	if ( nID == SC_MINIMIZE )
	{
		CString strTxtFile;

		strTxtFile.Format( "%s", GetWorkingPath( "PREVIEW.TXT" ) );

		CStdioFile	*pTxtFile = NULL;

		pTxtFile = new CStdioFile( strTxtFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeText );	

		pTxtFile->WriteString( "0" );

		pTxtFile->Close();

		delete pTxtFile;

		pTxtFile = NULL;
	}

	if ( nID == SC_RESTORE )
	{
		CString strTxtFile;

		strTxtFile.Format( "%s", GetWorkingPath( "PREVIEW.TXT" ) );

		CStdioFile	*pTxtFile = NULL;

		pTxtFile = new CStdioFile( strTxtFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeText );	

		pTxtFile->WriteString( "1" );

		pTxtFile->Close();

		delete pTxtFile;

		pTxtFile = NULL;
	}

	CDialogEx::OnSysCommand(nID,lParam); 
}